
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1100.C - Message 1100 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1100 messages.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\MSG1100.C_v  $
//   
//      Rev 1.16   07 Jan 2000 14:50:48   phungh
//   labmon60 : Add Magna BIT item to screen
//   
//      Rev 1.15   09 Nov 1998 10:47:48   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.3   Jul 09 1997 10:40:12   COLEJ
//    
//   
//      Rev 1.2   Feb 12 1997 16:05:20   COLEJ
//    
//   
//      Rev 1.1   Aug 14 1996 09:52:38   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:52:50   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <graph.h>
#include <conio.h>

#include "gentypes.h"
#include "ztypes.h"
#include "util.h"   
#include "display.h"   
#include "labmon.h"   
#include "monmisc.h"   
#include "menus.h"   
#include "monshow.h"   

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1100 message from the ZMsgBuf.
//
void Dec1100(tMSGBUF *ZMsgBuf, tMSG1100 *Msg)
{  
   GetShort  (&Msg->SequenceNumber    , ZMsgBuf, 8);   // ND
   GetUShort (&Msg->ROMFailure        , ZMsgBuf, 9);   // 1=failed
   GetUShort (&Msg->RAMFailure        , ZMsgBuf,10);   // 1=failed
   GetUShort (&Msg->EEPROMFailure     , ZMsgBuf,11);   // 1=failed
   GetUShort (&Msg->DPRAMFailure      , ZMsgBuf,12);   // 1=failed
   GetUShort (&Msg->DSPFailure        , ZMsgBuf,13);   // 1=failed
   GetUShort (&Msg->RTCFailure        , ZMsgBuf,14);   // 1=failed
   GetUShort (&Msg->SP1ErrorCount     , ZMsgBuf,15);   // ND
   GetUShort (&Msg->SP2ErrorCount     , ZMsgBuf,16);   // ND
   GetUShort (&Msg->SP1ReceiveCount   , ZMsgBuf,17);   // ND
   GetUShort (&Msg->SP2ReceiveCount   , ZMsgBuf,18);   // ND
   GetUShort (&Msg->SWVersion         , ZMsgBuf,19);   // ND
}

////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1100 message in the ZMsgBuf. 
//
void Bld1100(tMSGBUF *ZMsgBuf, tMSG1100 *Msg)
{
   // ack flags assumed preset

   PutShort  (0x81FF                   , ZMsgBuf, 1);   // message preamble
   PutShort  (1100                     , ZMsgBuf, 2);   // message number
   PutShort  (14                       , ZMsgBuf, 3);   // message length 
 //PutShort  (CheckSum(ZMsgBuf[0], 4)  , ZMsgBuf, 5);   // header check sum 
   
   PutShort  (Msg->SequenceNumber      , ZMsgBuf, 8);   // ND
   PutUShort (Msg->ROMFailure          , ZMsgBuf, 9);   // 1=failed
   PutUShort (Msg->RAMFailure          , ZMsgBuf,10);   // 1=failed
   PutUShort (Msg->EEPROMFailure       , ZMsgBuf,11);   // 1=failed
   PutUShort (Msg->DPRAMFailure        , ZMsgBuf,12);   // 1=failed
   PutUShort (Msg->DSPFailure          , ZMsgBuf,13);   // 1=failed
   PutUShort (Msg->RTCFailure          , ZMsgBuf,14);   // 1=failed
   PutUShort (Msg->SP1ErrorCount       , ZMsgBuf,15);   // ND
   PutUShort (Msg->SP2ErrorCount       , ZMsgBuf,16);   // ND
   PutUShort (Msg->SP1ReceiveCount     , ZMsgBuf,17);   // ND
   PutUShort (Msg->SP2ReceiveCount     , ZMsgBuf,18);   // ND
   PutUShort (Msg->SWVersion           , ZMsgBuf,19);   // ND
     
 //PutShort  (CheckSum(ZMsgBuf, 6,14)  , ZMsgBuf, 20);   // data check sum
}

////////////////////////////////////////////////////////////////////////////////
//   
//   Display a Zodiac 1100 message from the ZMsgBuf.
//
void Show1100(tMSG1100 *Msg)
{
   char         Buf[80] = "";
   float        SWVersion; 
   unsigned int DualPortRamWord;
   unsigned int MagnaWord;
     
   extern short BITTest; 
   extern short current_menu;  
   extern short MainTextColor;   
   extern short MainDataColor;
   
   // perform special processing for output 
   SWVersion = (float) (Msg->SWVersion) / 100.f;
   
   DualPortRamWord = (((Msg->DPRAMFailure >> 0) & 1) ? 1 : 0);
   MagnaWord       = (((Msg->DPRAMFailure >> 1) & 1) ? 1 : 0);
   
   _clearscreen(_GCLEARSCREEN);  
   _settextcolor(MainTextColor); 
    
   sprintf(Buf,"RECEIVER BUILT-IN TEST RESULTS"   );ShowText(Buf,BITR- 1,BITC+ 8);
   sprintf(Buf,"FUNCTIONAL TEST"                  );ShowText(Buf,BITR+ 1,BITC   ); 
   sprintf(Buf,"FAILURES"                         );ShowText(Buf,BITR+ 1,BITC+37); 
                                                                                                   
   sprintf(Buf,"READ-ONLY MEMORY (ROM)"           );ShowText(Buf,BITR+ 3,BITC   );
   sprintf(Buf,"RANDOM ACCESS MEMORY (RAM)"       );ShowText(Buf,BITR+ 4,BITC   );
   sprintf(Buf,"NON-VOLATILE STORAGE (EEPROM)"    );ShowText(Buf,BITR+ 5,BITC   );
   sprintf(Buf,"DUAL PORT RAM (DPRAM)"            );ShowText(Buf,BITR+ 6,BITC   );
   sprintf(Buf,"DIGITAL SIGNAL PROCESSOR (DSP)"   );ShowText(Buf,BITR+ 7,BITC   );
   sprintf(Buf,"REAL-TIME CLOCK (RTC)"            );ShowText(Buf,BITR+ 8,BITC   );
   sprintf(Buf,"H/W ACCELERATOR (MAGNA)"          );ShowText(Buf,BITR+ 9,BITC   );
   sprintf(Buf,"SERIAL PORT 1"                    );ShowText(Buf,BITR+10,BITC   );
   sprintf(Buf,"SERIAL PORT 2"                    );ShowText(Buf,BITR+11,BITC   );

   sprintf(Buf,"SERIAL PORT 1 RECEIVE COUNT"      );ShowText(Buf,BITR+13,BITC   );
   sprintf(Buf,"SERIAL PORT 2 RECEIVE COUNT"      );ShowText(Buf,BITR+14,BITC   );

   sprintf(Buf,"SOFTWARE VERSION"                 );ShowText(Buf,BITR+16,BITC+10);

   
   // output the data items   
   _settextcolor(MainDataColor);
   sprintf(Buf,"%04X",Msg->ROMFailure             );ShowText(Buf,BITR+ 3,BITC+39);
   sprintf(Buf,"%04X",Msg->RAMFailure             );ShowText(Buf,BITR+ 4,BITC+39);
   sprintf(Buf,"%04X",Msg->EEPROMFailure          );ShowText(Buf,BITR+ 5,BITC+39);
   sprintf(Buf,"%04X",DualPortRamWord             );ShowText(Buf,BITR+ 6,BITC+39);
   sprintf(Buf,"%04X",Msg->DSPFailure             );ShowText(Buf,BITR+ 7,BITC+39);
   sprintf(Buf,"%04X",Msg->RTCFailure             );ShowText(Buf,BITR+ 8,BITC+39);
   sprintf(Buf,"%04X",MagnaWord                   );ShowText(Buf,BITR+ 9,BITC+39);
   sprintf(Buf,"%5u" ,Msg->SP1ErrorCount          );ShowText(Buf,BITR+10,BITC+38);
   sprintf(Buf,"%5u" ,Msg->SP2ErrorCount          );ShowText(Buf,BITR+11,BITC+38);

   sprintf(Buf,"%5u" ,Msg->SP1ReceiveCount        );ShowText(Buf,BITR+13,BITC+38);
   sprintf(Buf,"%5u" ,Msg->SP2ReceiveCount        );ShowText(Buf,BITR+14,BITC+38);

   sprintf(Buf,"%.2f",SWVersion                   );ShowText(Buf,BITR+16,BITC+27);

   // pause until a key hit and restore screen
   getch();   
   _clearscreen(_GCLEARSCREEN);
   display_menus(&current_menu);   
   show_screen_titles(); 
   BITTest = FALSE;    
}
